/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.TimestampCopyingBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class TimestampBinder
extends DateCommonBinder {
    Binder theTimestampCopyingBinder = null;
    Timestamp paramVal;

    static void init(Binder x, int _scale) {
        x.type = (short)180;
        x.bytelen = 11;
        x.scale = (short)_scale;
    }

    TimestampBinder(Timestamp x) {
        TimestampBinder.init(this, -1);
        this.paramVal = x;
    }

    TimestampBinder(Timestamp x, int _scale) {
        TimestampBinder.init(this, _scale);
        this.paramVal = x;
    }

    @Override
    Binder copyingBinder() {
        if (this.theTimestampCopyingBinder == null) {
            this.theTimestampCopyingBinder = new TimestampCopyingBinder();
        }
        return this.theTimestampCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        Timestamp value = this.paramVal;
        byte[] b = null;
        int offset = 0;
        int len = 0;
        long pos = 0L;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                b = stmt.connection.methodTempLittleByteBuffer;
                byteoffset = 0;
                offset = 0;
            } else {
                b = bindBytes;
                offset = byteoffset;
            }
            bindIndicators[indoffset] = 0;
            len = this.getDatumBytes(stmt, value, b, offset, bindUseDBA, bytePitch);
        }
        if (bindUseDBA) {
            bindData.put(b, 0, len);
            bindIndicators[indoffset] = 0;
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindIndicators[lenoffset] = (short)len;
        } else {
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)len;
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value.getTime());
        }
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, Timestamp value, byte[] b, int offset, boolean bindUseDBA, int bytePitch) throws SQLException {
        int len = 0;
        TimestampBinder.setOracleHMS(TimestampBinder.setOracleCYMD(value.getTime(), b, offset, stmt), b, offset);
        int nanos = value.getNanos();
        if (nanos != 0) {
            TimestampBinder.setOracleNanos(nanos, b, offset);
            len = bindUseDBA ? 11 : bytePitch;
        } else {
            len = 7;
        }
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0, true, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

