"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppAnalyticsAdaptor = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AppAnalyticsAdaptor {
  constructor() {
    // Fetch all existing applications
    _defineProperty(this, "fetchApps", async client => {
      try {
        const response = await client.callAsCurrentUser('observability.getObject', {
          objectType: 'application'
        });
        return response.observabilityObjectList.map(object => {
          return {
            id: object.objectId,
            dateCreated: object.createdTimeMs,
            dateModified: object.lastUpdatedTimeMs,
            name: object.application.name,
            description: object.application.description,
            baseQuery: object.application.baseQuery,
            servicesEntities: object.application.servicesEntities.map(rec => decodeURI(rec)),
            traceGroups: object.application.traceGroups.map(rec => decodeURI(rec)),
            panelId: object.application.panelId,
            availability: {
              name: '',
              color: '',
              availabilityVisId: object.application.availabilityVisId || ''
            }
          };
        });
      } catch (err) {
        throw new Error('Fetch All Applications Error: ' + err);
      }
    });
    // Fetch application by id
    _defineProperty(this, "fetchAppById", async (client, appId) => {
      try {
        const response = await client.callAsCurrentUser('observability.getObjectById', {
          objectId: appId
        });
        const app = response.observabilityObjectList[0];
        return {
          id: appId,
          dateCreated: app.createdTimeMs,
          dateModified: app.lastUpdatedTimeMs,
          name: app.application.name,
          description: app.application.description,
          baseQuery: app.application.baseQuery,
          servicesEntities: app.application.servicesEntities.map(rec => decodeURI(rec)),
          traceGroups: app.application.traceGroups.map(rec => decodeURI(rec)),
          panelId: app.application.panelId,
          availability: {
            name: '',
            color: '',
            availabilityVisId: app.application.availabilityVisId || ''
          }
        };
      } catch (err) {
        throw new Error('Fetch Application By Id Error: ' + err);
      }
    });
    // Create a new application
    _defineProperty(this, "createNewApp", async (client, appBody) => {
      try {
        const response = await client.callAsCurrentUser('observability.createObject', {
          body: {
            application: appBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Create New Application Error: ' + err);
      }
    });
    // Rename an existing application
    _defineProperty(this, "renameApp", async (client, appId, name) => {
      const updateApplicationBody = {
        name
      };
      try {
        const response = await client.callAsCurrentUser('observability.updateObjectById', {
          objectId: appId,
          body: {
            application: updateApplicationBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Rename Application Error: ' + err);
      }
    });
    // Update an existing application
    _defineProperty(this, "updateApp", async (client, appId, updateAppBody) => {
      try {
        const response = await client.callAsCurrentUser('observability.updateObjectById', {
          objectId: appId,
          body: {
            application: updateAppBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Update Panel Error: ' + err);
      }
    });
    // Delete existing applications
    _defineProperty(this, "deleteApp", async (client, appList) => {
      try {
        const response = await client.callAsCurrentUser('observability.deleteObjectByIdList', {
          objectIdList: appList
        });
        return {
          status: 'OK',
          message: response
        };
      } catch (err) {
        throw new Error('Delete Application Error: ' + err);
      }
    });
  }
}
exports.AppAnalyticsAdaptor = AppAnalyticsAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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