/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public abstract class AbstractCredentialsAgent
implements CredentialsAgent {
    private static volatile CredentialsProvider credentialsProvider = (a, b, c, d, e, f) -> Logging.error("Credentials provider has not been set");
    protected Map<Pair<Authenticator.RequestorType, String>, PasswordAuthentication> memoryCredentialsCache = new HashMap<Pair<Authenticator.RequestorType, String>, PasswordAuthentication>();

    public static void setCredentialsProvider(CredentialsProvider provider) {
        credentialsProvider = Objects.requireNonNull(provider, "provider");
    }

    @Override
    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String host, boolean noSuccessWithLastResponse) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication credentials = this.lookup(requestorType, host);
        String username = credentials == null || credentials.getUserName() == null ? "" : credentials.getUserName();
        String password = credentials == null || credentials.getPassword() == null ? "" : String.valueOf(credentials.getPassword());
        CredentialsAgentResponse response = new CredentialsAgentResponse();
        Pair<Authenticator.RequestorType, String> mccKey = Pair.create(requestorType, host);
        if (!noSuccessWithLastResponse && this.memoryCredentialsCache.containsKey(mccKey) && (credentials == null || credentials.getPassword() == null || credentials.getPassword().length == 0)) {
            PasswordAuthentication pa = this.memoryCredentialsCache.get(mccKey);
            response.setUsername(pa.getUserName());
            response.setPassword(pa.getPassword());
            response.setCanceled(false);
        } else if (noSuccessWithLastResponse || username.isEmpty() || password.isEmpty()) {
            credentialsProvider.provideCredentials(requestorType, this, response, username, password, host);
            if (response.isCanceled() || response.getUsername() == null || response.getPassword() == null) {
                return response;
            }
            if (response.isSaveCredentials()) {
                this.store(requestorType, host, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            } else {
                this.memoryCredentialsCache.put(mccKey, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            }
        } else {
            response.setUsername(username);
            response.setPassword(password.toCharArray());
            response.setCanceled(false);
        }
        return response;
    }

    @Override
    public final void purgeCredentialsCache(Authenticator.RequestorType requestorType) {
        this.memoryCredentialsCache.keySet().removeIf(pair -> pair.a == requestorType);
    }

    @Override
    public void purgeCredentialsCache(Authenticator.RequestorType requestorType, String host) {
        this.memoryCredentialsCache.remove(Pair.create(requestorType, host));
    }

    public abstract String getSaveUsernameAndPasswordCheckboxText();

    @FunctionalInterface
    public static interface CredentialsProvider {
        public void provideCredentials(Authenticator.RequestorType var1, AbstractCredentialsAgent var2, CredentialsAgentResponse var3, String var4, String var5, String var6);
    }
}

