# node-fstab
by Moe Alam, Shinobi Systems

> Currently for internal use at Shinobi Systems and is included in ShinobiCCTV software.

The **node-fstab** module provides a suite of tools for managing filesystem mounts in a Unix-like environment using Node.js. It includes functions to create mount points, mount/unmount filesystems, update and remove entries in `/etc/fstab`, list mounts, and retrieve disk usage information.

Installation
------------

    npm install node-fstab

Usage
-----

### Importing the Module

    const { createMountPoint, mount, update, remove, list, remountAll, remount, unmount, getDiskUsage, writeReadStream, checkDiskPathExists, execAsync } = require('node-fstab');

Functions
---------

### createMountPoint(path)

Creates a directory for a mount point if it doesn’t already exist.

*   `path`: _String_ - Path of the mount point.
*   Returns: An object with `ok` status and `error` message if any.

### mount(server, remotePath, localPath, type = 'cifs', options = 'username=username,password=password')

Mounts a filesystem (e.g., CIFS or NFS) with customizable options.

*   `server`: _String_ - The server IP or hostname.
*   `remotePath`: _String_ - The remote directory to mount.
*   `localPath`: _String_ - The local mount point path.
*   `type`: _String_ - Filesystem type (default: 'cifs').
*   `options`: _String_ - Mount options, such as credentials.

### update(sourceTarget, localPath, mountType = 'cifs', fstabOptions = 'username=username,password=password,rw,iocharset=utf8,file\_mode=0777,dir\_mode=0777 0 0')

Updates or adds an entry in `/etc/fstab`. Removes any existing entry with the same `localPath` before appending a new entry.

*   `sourceTarget`: _String_ - The source device or server path.
*   `localPath`: _String_ - The mount point on the local system.
*   `mountType`: _String_ - Type of filesystem (e.g., 'cifs').
*   `fstabOptions`: _String_ - Mount options to be used in `/etc/fstab`.

### remove(localPath)

Removes a mount entry from `/etc/fstab` based on `localPath`.

*   `localPath`: _String_ - The mount point path to remove from `/etc/fstab`.

### list()

Lists all entries in `/etc/fstab` as an array of objects.

*   Returns: An array of objects, each with `device`, `mountPoint`, `type`, and `options`.

### remountAll()

Remounts all filesystems listed in `/etc/fstab`.

*   Returns: An object with `ok` status and message upon completion.

### remount(mountPath)

Remounts a specific mount point defined in `/etc/fstab`.

*   `mountPath`: _String_ - Path of the mount point to remount.

### unmount(localPath)

Unmounts a specified mount point.

*   `localPath`: _String_ - The local path to unmount.

### getDiskUsage()

Provides disk usage information using `df -h` as an array of objects.

*   Returns: An array of objects, each with fields from `df -h` such as `filesystem`, `size`, `used`, `avail`, `use%`, and `mounted`.

### checkDiskPathExists(localPath)

Checks if a specific path exists among the mounted filesystems.

*   `localPath`: _String_ - The path to check.

### writeReadStream(readerStream, outputFile)

Pipes data from a read stream to an output file with error handling.

*   `readerStream`: _Stream_ - The read stream to pipe data from.
*   `outputFile`: _String_ - The output file to write data to.

Examples
--------

### Mount a CIFS Share


    const { mount } = require('node-fstab');

    (async () => {
      const server = '192.168.1.200';
      const remotePath = '/shared/folder';
      const localPath = '/mnt/cifs_share';
      const options = 'username=myuser,password=mypass';

      const response = await mount(server, remotePath, localPath, 'cifs', options);
      if (response.ok) {
        console.log(`Mounted CIFS share at ${localPath}`);
      } else {
        console.error(`Error: ${response.error}`);
      }
    })();


License
-------

This project is licensed under the MIT License.
